-- moonloader/lib/samp.lua
-- Standard SA-MP Events Library for Moonloader
-- This library provides access to SAMPFUNCS functions and events.

local ffi = require 'ffi'
local sf = require 'sampfuncs'

local samp = {
    events = {}
}

-- You can add more functions here as needed, but for now, we'll just define the ones we need.
-- This is a simplified structure for clarity. A full samp.lua library is much larger.

function samp.get3dTextLabelInfoById(id)
    return sf.samp_get_3d_text_label_info_by_id(id)
end

function samp.setVirtualKeyUp(key, state)
    sf.set_virtual_key_state(key, state)
end

-- Event handlers
local oldOnServerMessage = samp.events.onServerMessage
function samp.events.onServerMessage(color, text)
    if oldOnServerMessage then oldOnServerMessage(color, text) end
end

-- This is a simplified representation. A full library would have a more complex event manager.
-- For the purpose of this script, this structure will work.

return samp