script_name("FuelWarning")
script_author("ncta")

local sampev = require 'lib.samp.events'

local lowFuelValue = 3.0
local fuelL = nil
local lastCheck = 0
local warnWindowEnd = 0  -- timestamp until which the warning is allowed to draw (2s window)

local function showOnceFor2s()
    local v = fuelL and string.format("%.1f", fuelL) or "?"
    printStringNow("~r~~h~LOW FUEL (" .. v .. "L)~n~~w~Find a gas station!", 2000)
    warnWindowEnd = os.clock() + 2.0
end

local function parseFuel(str)
    if not str then return nil end
    local u = tostring(str):upper()
    local n = u:match("FUEL:%s*([%d]+%.?[%d]*)L")
    return n and tonumber(n) or nil
end

function main()
    repeat wait(0) until isSampAvailable()
    while true do
        wait(0)

        if not isCharInAnyCar(PLAYER_PED) then
            warnWindowEnd = 0
        else
            -- periodic check every 5s
            if os.clock() - lastCheck >= 5 then
                lastCheck = os.clock()

                --  local dbgFuel = fuelL and string.format("%.1f", fuelL) or "nil"
                --  local cmp = "n/a"
                --  if fuelL then
                --     cmp = (fuelL < lowFuelValue) and "inferior" or "superior"
                -- end
                --      sampAddChatMessage(
                -- string.format("[FW-DEBUG] Fuel=%s | threshold=%.1f | cmp=%s | inCar=true",
                --         dbgFuel, lowFuelValue, cmp),
                --     0xFFFF00
                -- )

                -- if under threshold, open a 2s warning window
                if fuelL and fuelL < lowFuelValue then
                    showOnceFor2s()
                else
                    warnWindowEnd = 0
                end
            end
            -- draw only while inside the 2s window
            if warnWindowEnd > 0 and os.clock() < warnWindowEnd then
            local v = fuelL and string.format("%.1f", fuelL) or "?"
            printStringNow("~r~~h~LOW FUEL (" .. v .. "L)~n~~w~Find a gas station!", 200)
            end
        end
    end
end

function sampev.onShowTextDraw(id, data)
    local v = parseFuel(data and data.text)
    if v then fuelL = v end
end

function sampev.onTextDrawSetString(id, text)
    local v = parseFuel(text)
    if v then fuelL = v end
end