script_name("Current Car HP")
script_author("v0")
script_version("1.0")

require "lib.moonloader"

-- Cache
local prefix = "{00ff00}[Current Car HP]: {ffffff}"
local active = true

-- Updated font settings to match slotsUsed.lua exactly
local font_name = "Verdana"
local font_size = 12
local font_flags = 12

function main()
    -- Wait until SA-MP is loaded
    while not isSampAvailable() do
        wait(100)
    end

    -- Register toggle command
    sampRegisterChatCommand("carhp", function()
        active = not active
        sampAddChatMessage(prefix.."Current Car HP display "..(active and "ON" or "OFF"), -1)
    end)

    -- Create font using exact same parameters as slotsUsed.lua
    local Font = renderCreateFont(font_name, font_size, font_flags)
    
    while true do
        wait(0)
        
        if active and isPlayerPlaying(PLAYER_HANDLE) then
            -- Check if player is in a vehicle
            if isCharInAnyCar(playerPed) then
                -- Get the vehicle the player is currently using
                local currentVehicle = getCarCharIsUsing(playerPed)
                
                if currentVehicle then
                    -- Get vehicle health
                    local health = getCarHealth(currentVehicle)
                    
                    -- Added reactive color system based on HP ranges
                    local color
                    if health >= 1500 then
                        color = "{00FF00}"  -- Green (was light green)
                    elseif health >= 1000 then
                        color = "{90EE90}"  -- Light green (was green)
                    elseif health >= 750 then
                        color = "{FFFF00}"  -- Yellow
                    elseif health >= 500 then
                        color = "{FFA500}"  -- Orange
                    else
                        color = "{FF0000}"  -- Red
                    end
                    
                    -- Use exact same positioning as slotsUsed.lua
                    local pos_x, pos_y = getScreenResolution()
                    local fontPositionX = 30
                    local fontPositionY = pos_y - 80
                    
                    -- Updated text formatting to use reactive color
                    local text = string.format("%s%d", color, math.floor(health))
                    renderFontDrawText(Font, text, fontPositionX, fontPositionY, -1)
                end
            end
        end
    end
end
