script_name("AutoCar")
script_author("BloodNeko")
script_version("1.0")
script_description("Automatically handles car functions")

local sampev = require 'lib.samp.events'
local enabled = true
local lockOnEnter = false
local isEntering = false

local VEHICLE_TYPES = {
  bike    = {448,461,462,463,468,521,522,523,581,586},
  bicycle = {509,481,510},
  boat    = {472,473,493,595,484,430,453,452,446,454},
  plane   = {592,577,511,512,593,520,553,476,519,460,513},
  heli    = {548,425,417,487,488,497,563,447,469}
}

local vehicleSet = {}
for t, list in pairs(VEHICLE_TYPES) do
  vehicleSet[t] = {}
  for _, id in ipairs(list) do
    vehicleSet[t][id] = true
  end
end

local function getVehicleClass(model)
  for t, set in pairs(vehicleSet) do
    if set[model] then return t end
  end
  return 'car'
end

function debugEngine(veh)
  local state = isCarEngineOn(veh) and "ON" or "OFF"
  local msg = string.format("[AutoCar] Vehicle engine: %s", state)
  sampAddChatMessage(msg, -1)
end

function debugTime()
  local hour, min = getTimeOfDay()
  local label = (hour >= 18 or hour < 6) and "Night" or "Day"
  local msg = string.format("[AutoCar] Current time: %02d:%02d (%s)", hour, min, label)
  sampAddChatMessage(msg, -1)
end

function toggleScript()
  enabled = not enabled
  local status = enabled and "enabled" or "disabled"
  sampAddChatMessage("[AutoCar] Script is now " .. status, -1)
end

function sampev.onSendEnterVehicle(id, pass)
  if not enabled or isEntering then return end

  lua_thread.create(function()
    isEntering = true
    while not isCharInAnyCar(PLAYER_PED) do wait(10) end
    wait(500)
    local veh = storeCarCharIsInNoSave(PLAYER_PED)
    local ok, model = pcall(getCarModel, veh)
    if not ok then isEntering = false return end
    local class = getVehicleClass(model)
    if not pass and class ~= 'bicycle' then
      if not isCarEngineOn(veh) then sampSendChat('/engine') end
    end
    if not pass and lockOnEnter then sampSendChat('/lock') end
    if class == 'car' then wait(750); sampSendChat('/seatbelt') end
    isEntering = false
  end)
end


function debugCar()
  if isCharInAnyCar(PLAYER_PED) then
    local veh = storeCarCharIsInNoSave(PLAYER_PED)
    debugEngine(veh)
    debugTime()
    local model = getCarModel(veh)
    local msg = string.format("[AutoCar] Vehicle model ID: %d", model)
    sampAddChatMessage(msg, -1)
  else
    sampAddChatMessage("[AutoCar] You're not in a vehicle", -1)
  end
end

function sampev.onSendCommand(cmd)
  if cmd == "/autocar lock" then
    lockOnEnter = not lockOnEnter
    sampAddChatMessage("[AutoCar] Auto-lock is now " .. (lockOnEnter and "enabled" or "disabled"), -1)
    return false
  elseif cmd == "/autocar" then
    toggleScript()
    return false
  elseif cmd == "/debugcar" then
    debugCar()
    return false
  end
end
