script_name("Reconnect")
script_description("Reconnect to your server using this script!")
script_version_number("1")
script_version("1.3")
script_authors("Brad Ringer")
script_dependencies("None")

PressType = {KeyDown = isKeyDown, KeyPressed = wasKeyPressed}

-- Change the keys  from here:
-- Default: Key1 = LSHIFT, KEY2 = 0
key1 = 48
key2 = 160
-- KEY IDs: http://ugbase.eu/index.php?threads/all-virtual-key-codes.2154/

function main()
	repeat wait(0) until isSampAvailable()
		sampRegisterChatCommand("reconhelp", reconhelp)
		sampRegisterChatCommand("recon", reconnect)
		sampRegisterChatCommand("name", name)
		while true do
		wait(50)
		server, port = sampGetCurrentServerAddress()
		id = sampGetPlayerIdByCharHandle(PLAYER_PED)
		if check({k  = {key1}, t = {'KeyDown', 'KeyPressed'}}) and isKeyAvailable() and isKeyDown(key2) then
			reconnect()
			wait(2000)
		end
	end
end

function check(k)
    local r = true
    for i = 1, #k.k do
        r = r and PressType[k.t[i]](k.k[i])
	end
    return r
end

function isKeyAvailable()
	if not isSampLoaded() then return true end
	if not sampIsChatInputActive() then return not sampIsDialogActive() end
	return not sampIsChatInputActive() and not sampIsDialogActive()
end

function reconnect()
	sampConnectToServer(server,port)
end

function name(name)
	nick = sampGetPlayerNickname(id)
	if(string.len(name) > 0 and string.len(name) < 3 or string.len(name) > 20) then
		sampAddChatMessage("[Reconnect] {FFFFFF}The name can not be lower than 3 or greater than 20 characters (samp restriction)", 0x686868)
		return
	elseif(string.find(name, "{") or string.find(name, "}") or string.find(name, "-") or string.find(name, "+") or string.find(name, "*") or string.find(name, "/") or string.find(name, "?") or string.find(name, "<") or string.find(name, ">") or string.find(name, "|") or string.find(name, "!")) then
		sampAddChatMessage("[Reconnect] {FFFFFF}The only characters you can use are: a-z, A-Z, 1-9, _, [ ]", 0x686868)
		return
	--elseif(string.find(name, "%") or string.find(name, "^") or string.find(name, "&") or string.find(name, "(") or string.find(name, ")") or string.find(name, "=")) then
	--	sampAddChatMessage("[Reconnect] {FFFFFF}The only characters you can use are: a-z, A-Z, 1-9, _, [ ]", 0x686868)
	--	return -------- Not used because it makes the script not functions probably because of too many string.finds
	elseif(name == "") then
		sampAddChatMessage("[Reconnect] {FFFFFF}Usage: {686868}[/name Brad_Ringer]", 0x686868)
		return
	elseif(nick == name) then
		sampAddChatMessage("[Reconnect] {FFFFFF}You are already connected with that name!", 0x686868)
		return
	end
	reconnect()
	sampSetLocalPlayerName(name)
end

function reconhelp()
	sampAddChatMessage("{686868}[------- [Reconnect] - Developed by: Brad Ringer -------]", 0xFFFFFF)
	sampAddChatMessage("", 0xFFFFFF)
	sampAddChatMessage("{686868}[/reconnect] - Reconnect to the server you are currently logged in at", 0xFFFFFF)
	sampAddChatMessage("{686868}[/name] - Changes your name (reconnects you to the server as well)", 0xFFFFFF)
	sampAddChatMessage("{686868}You can also reconnect using a key combination (Default: LSHIFT, 0)", 0xFFFFFF)
end
